/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ItemUtils;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import morph.avaritia.api.CompressorRecipe;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.recipe.CompressorRecipeHelper;
import morph.avaritia.tile.MachineTileBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutroniumCompressorTile
extends MachineTileBase {
    public static int CONSUME_TICKS = 1;
    public final Inventory inventory = new Inventory();
    private ItemStack targetStack = ItemStack.f_41583_;
    private int compressionTarget;
    private int consumptionProgress;
    private int compressionProgress;
    private List<ItemStack> c_InputItems = ImmutableList.of();
    private LazyOptional<IItemHandler> nullWrapper = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    private LazyOptional<IItemHandlerModifiable>[] sidedWrappers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])Direction.values());

    public NeutroniumCompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)AvaritiaModContent.COMPRESSOR_TILE.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.compressionTarget == -1) {
            CompressorRecipe recipe = CompressorRecipeHelper.getRecipeFromResult(this.f_58857_, this.targetStack);
            if (recipe == null) {
                this.targetStack = ItemStack.f_41583_;
                this.compressionTarget = 0;
                this.consumptionProgress = 0;
                this.compressionProgress = 0;
            } else {
                this.compressionTarget = recipe.getCost();
            }
        }
    }

    @Override
    protected void doWork() {
        if (this.targetStack.m_41619_()) {
            this.fullContainerSync = true;
            CompressorRecipe recipe = CompressorRecipeHelper.getRecipe(this.f_58857_, this.inventory.getInput());
            this.targetStack = recipe.m_8043_();
            this.compressionTarget = recipe.getCost();
        }
        ++this.consumptionProgress;
        if (this.consumptionProgress >= CONSUME_TICKS) {
            this.consumptionProgress = 0;
            this.inventory.m_7407_(0, 1);
            ++this.compressionProgress;
        }
        if (this.compressionProgress >= this.compressionTarget) {
            this.compressionProgress = 0;
            ItemStack output = this.inventory.getOutput();
            if (output.m_41619_()) {
                this.inventory.m_6836_(1, ItemUtils.copyStack((ItemStack)this.targetStack, (int)1));
            } else {
                this.inventory.m_6836_(1, ItemUtils.copyStack((ItemStack)output, (int)(output.m_41613_() + 1)));
            }
            this.targetStack = ItemStack.f_41583_;
            this.fullContainerSync = true;
        }
    }

    @Override
    protected void onWorkStopped() {
        this.consumptionProgress = 0;
    }

    @Override
    protected boolean canWork() {
        ItemStack input = this.inventory.getInput();
        if (input.m_41619_()) {
            return false;
        }
        if (!this.targetStack.m_41619_()) {
            return CompressorRecipeHelper.inputMatchesRecipeForOutput(this.f_58857_, input, this.targetStack);
        }
        CompressorRecipe recipe = CompressorRecipeHelper.getRecipe(this.f_58857_, input);
        if (recipe == null) {
            return false;
        }
        ItemStack output = this.inventory.getOutput();
        if (output.m_41619_()) {
            return true;
        }
        return recipe.m_8043_().m_41656_(output) && output.m_41613_() < Math.min(output.m_41741_(), this.inventory.m_6893_());
    }

    @Override
    public void writeGuiData(MCDataOutput packet, boolean isFullSync) {
        packet.writeVarInt(this.consumptionProgress);
        packet.writeVarInt(this.compressionProgress);
        if (isFullSync) {
            packet.writeItemStack(this.targetStack);
            packet.writeVarInt(this.compressionTarget);
        }
    }

    @Override
    public void readGuiData(MCDataInput packet, boolean isFullSync) {
        this.consumptionProgress = packet.readVarInt();
        this.compressionProgress = packet.readVarInt();
        if (isFullSync) {
            this.targetStack = packet.readItemStack();
            this.compressionTarget = packet.readVarInt();
            LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
            if (!this.targetStack.m_41619_()) {
                NonNullList ings = CompressorRecipeHelper.getRecipeFromResult(this.f_58857_, this.targetStack).m_7527_();
                for (Ingredient ing : ings) {
                    Collections.addAll(inputs, ing.m_43908_());
                }
            }
            this.c_InputItems = inputs;
        }
    }

    public int getCompressionProgress() {
        return this.compressionProgress;
    }

    public int getCompressionTarget() {
        return this.compressionTarget;
    }

    public int getConsumptionProgress() {
        return this.consumptionProgress;
    }

    public int getConsumptionTarget() {
        return this.compressionProgress;
    }

    public ItemStack getTargetStack() {
        return this.targetStack;
    }

    public List<ItemStack> getInputItems() {
        return this.c_InputItems;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)InventoryUtils.writeItemStacksToTag((ItemStack[])this.inventory.items));
        tag.m_128365_("target", (Tag)this.targetStack.m_41739_(new CompoundTag()));
        tag.m_128405_("consumptionProgress", this.consumptionProgress);
        tag.m_128405_("compressionProgress", this.compressionProgress);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.inventory.items, (ListTag)tag.m_128437_("inventory", 10));
        this.consumptionProgress = tag.m_128451_("consumptionProgress");
        this.compressionProgress = tag.m_128451_("compressionProgress");
        this.targetStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("target"));
        this.compressionTarget = -1;
        this.fullContainerSync = true;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.nullWrapper.invalidate();
        for (LazyOptional<IItemHandlerModifiable> sidedWrapper : this.sidedWrappers) {
            sidedWrapper.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.nullWrapper = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
        this.sidedWrappers = SidedInvWrapper.create((WorldlyContainer)this.inventory, (Direction[])Direction.values());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.nullWrapper.cast();
            }
            return this.sidedWrappers[side.ordinal()].cast();
        }
        return super.getCapability(cap, side);
    }

    public class Inventory
    extends InventorySimple
    implements WorldlyContainer {
        public Inventory() {
            super(2);
        }

        public ItemStack getInput() {
            return this.items[0];
        }

        public ItemStack getOutput() {
            return this.items[1];
        }

        public void m_6596_() {
            NeutroniumCompressorTile.this.m_6596_();
        }

        public int[] m_7071_(Direction side) {
            int[] nArray;
            if (side == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 1;
            }
            return nArray;
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            if (slot != 0) {
                return false;
            }
            if (NeutroniumCompressorTile.this.targetStack.m_41619_()) {
                return CompressorRecipeHelper.getRecipe(NeutroniumCompressorTile.this.f_58857_, stack) != null;
            }
            return CompressorRecipeHelper.inputMatchesRecipeForOutput(NeutroniumCompressorTile.this.f_58857_, stack, NeutroniumCompressorTile.this.targetStack);
        }

        public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction side) {
            return this.m_7013_(slot, stack);
        }

        public boolean m_7157_(int slot, ItemStack stack, Direction side) {
            return slot == 1 && side != Direction.UP;
        }
    }
}

